# SocketWrench 11

Version 11.0.2235.1894
This release of SocketWrench includes .NET assemblies, ActiveX controls (OCXs) and dynamic link libraries (DLLs) for the Windows platform. All components are digitally signed and can be redistributed to end users.

When you install a new version of SocketWrench on your development system, you will be prompted to provide your product serial number, or you can install with an evaluation license which is valid for thirty (30) days. If you are updating SocketWrench, it is not necessary to uninstall the previous version. The installer will automatically update the components on your development system using your existing license.

SocketWrench 11 can be installed side-by-side with previous versions. For example, you can have both SocketWrench 10 and SocketWrench 11 installed on the same development system. However, you should not attempt to reference different versions of the same component within a project.

The SocketWrench product is a subset of each of the SocketTools editions which includes the general purpose SocketWrench TCP/IP component and the InternetServer component. If you require support for high-level application Internet protocols, it is recommended you select one of the SocketTools editions.

- [SocketTools .NET Edition](https://sockettools.com/sockettools-net-edition/)
- [SocketTools ActiveX Edition](https://sockettools.com/sockettools-activex-edition/)
- [SocketTools Library Edition](https://sockettools.com/sockettools-library-edition/)

If your projects require multiple component types, for example both .NET assemblies and ActiveX controls, the [SocketTools Subscription](https://sockettools.com/sockettools-subscription/) includes every assembly, control and library available in each of the editions. The annual subscription is a perpetual license and includes free upgrades and priority technical support during the subscription period.

This release includes assemblies for .NET 9.0 and Visual Studio 2022 17.14. Unless you have a specific need for features introduced with .NET 9.0, we recommend you continue to use the .NET 8.0 LTS release which is supported until November, 2026.

## Installation

The self-installing executable in this archive will install SocketWrench for use in a development environment. It should not be used to install the SocketWrench components on an end-user system.

To assist with deployment to end users, we provide Windows Installer (MSI) packages which can be used install the redistributable components. For more information, refer to our Knowledge Base [article](https://sockettools.com/kb/sockettools-windows-installer-packages/).

By default, SocketWrench will be installed to **C:\Program Files (x86)\SocketWrench 11.0** and you can change this folder with new installations. If you are updating SocketWrench, the installer will replace files in the original installation folder.

Although SocketWrench defaults to the 32-bit Program Files folder, it will install both 32-bit and 64-bit components on a 64-bit Windows system. The .NET assemblies are installed in the common folder **C:\Program Files (x86)\Common Files\SocketTools\11.0\Assemblies** and are platform neutral. They can be referenced by projects which target either the x86 or x64 platforms.

SocketWrench 11 is not supported on Windows XP, Windows Vista or Windows Server 2003. An error message will be displayed if you attempt to install SocketWrench on an unsupported platform.

## Digital Signatures

The SocketWrench installer packages and components have been digitally signed with an extended validation (EV) Authenticode certificate which uses SHA-256 signatures. Security software on older, unsupported platforms may report the installers as having an invalid certificate because they only recognize MD5 and SHA-1 signatures.

## Redistribution

If you are installing SocketWrench with an evaluation license, you will not be able to redistribute the components to another system. The evaluation license is only valid on the local system for testing purposes by the user who installed the product.

If you install SocketWrench with a serial number, it will create the development license required to redistribute the components to other users. There are no additional runtime licensing requirements, and the components can be redistributed to as many end users as required.

SocketWrench is a combined subset of the three SocketTools editions. For assistance with deploying your applications, we have Knowledge Base articles for each component type included with SocketWrench:

- [SocketTools .NET Redistribution](https://sockettools.com/kb/sockettools-11-dotnet-redistribution/)

- [SocketTools ActiveX Redistribution](https://sockettools.com/kb/sockettools-11-activex-redistribution/)

- [SocketTools Library Redistribution](https://sockettools.com/kb/sockettools-11-library-redistribution/)

The articles describe how to create the runtime license key for your projects and how it is used. The requirements are similar for each component type, and the same license key should be used with each component. 

## System Requirements

SocketWrench 11 supports all modern Windows desktop and server platforms. We recommend you install the latest security updates from Windows Update and the current network drivers available for your system. The minimum supported platform is Windows 7 SP1 and Windows Server 2008 R2.

SocketWrench includes both 32-bit and 64-bit components. We recommend development on 64-bit versions of Windows, and for the broadest compatibility with most end-user systems, we recommend targeting your project for the x86 (32-bit) platform.

Targeting the x86 platform will ensure your application will work on both 32-bit and 64-bit Windows. A 32-bit application can run on 64-bit Windows under WoW64; however, a 64-bit application cannot run on 32-bit versions of Windows.

## Examples

The examples for SocketWrench are placed in your Documents folder, under **SocketTools Examples**. They are placed there so you can easily modify them without having to copy them out of the installation folder.

